<?php $__env->startSection('panel'); ?>
    <div class="row mt-50 mb-none-30">
        <div class="col-xl-3 col-lg-6 col-sm-6 mb-30">
            <div class="dashboard-w1 bg--19 b-radius--10 box-shadow" >
                <div class="icon">
                    <i class="fa fa-wallet"></i>
                </div>
                <div class="details">
                    <div class="numbers">
                        <span class="amount"><?php echo e($sendCourierCount); ?></span>
                    </div>
                    <div class="desciption">
                        <span><?php echo app('translator')->get('Total Dispatch Courier'); ?></span>
                    </div>
                    <a href="<?php echo e(route('staff.send.courier.list')); ?>" class="btn btn-sm text--small bg--white text--black box--shadow3 mt-3"><?php echo app('translator')->get('View All'); ?></a>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-sm-6 mb-30">
            <div class="dashboard-w1 bg--3 b-radius--10 box-shadow" >
                <div class="icon">
                    <i class="fa fa-spinner"></i>
                </div>
                <div class="details">
                    <div class="numbers">
                        <span class="amount"><?php echo e($receivedCourierCount); ?></span>
                    </div>
                    <div class="desciption">
                        <span><?php echo app('translator')->get('Total Received Courier'); ?></span>
                    </div>
                    <a href="<?php echo e(route('staff.received.courier.list')); ?>" class="btn btn-sm text--small bg--white text--black box--shadow3 mt-3"><?php echo app('translator')->get('View All'); ?></a>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-sm-6 mb-30">
            <div class="dashboard-w1 bg--12 b-radius--10 box-shadow" >
                <div class="icon">
                    <i class="fa fa-money-bill-alt"></i>
                </div>
                <div class="details">
                    <div class="numbers">
                        <span class="amount"><?php echo e($branchCount); ?></span>
                    </div>
                    <div class="desciption">
                        <span><?php echo app('translator')->get('Total Brach'); ?></span>
                    </div>

                    <a href="<?php echo e(route('staff.branch.index')); ?>" class="btn btn-sm text--small bg--white text--black box--shadow3 mt-3"><?php echo app('translator')->get('View All'); ?></a>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-sm-6 mb-30">
            <div class="dashboard-w1 bg--6 b-radius--10 box-shadow">
                <div class="icon">
                    <i class="fa fa-hand-holding-usd"></i>
                </div>
                <div class="details">
                    <div class="numbers">
                        <span class="amount"><?php echo e($general->cur_sym); ?><?php echo e(getAmount($cashCollection)); ?></span>
                    </div>
                    <div class="desciption">
                        <span><?php echo app('translator')->get('Total Cash Collection'); ?></span>
                    </div>

                    <a href="<?php echo e(route('staff.cash.income')); ?>" class="btn btn-sm text--small bg--white text--black box--shadow3 mt-3"><?php echo app('translator')->get('View All'); ?></a>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-30">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Sender Branch - Staff'); ?></th>
                                    <th><?php echo app('translator')->get('Receiver Branch - Staff'); ?></th>
                                    <th><?php echo app('translator')->get('Amount - Order Number'); ?></th>
                                    <th><?php echo app('translator')->get('Creations Date'); ?></th>
                                    <th><?php echo app('translator')->get('Payment Status'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $courierDeliveys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courierInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td data-label="<?php echo app('translator')->get('Sender Branch'); ?>">
                                    <span><?php echo e(__($courierInfo->senderBranch->name)); ?></span><br>
                                    <?php echo e(__($courierInfo->senderStaff->fullname)); ?>

                                </td>

                                <td data-label="<?php echo app('translator')->get('Receiver Branch - Staff'); ?>">
                                    <span>
                                        <?php if($courierInfo->receiver_branch_id): ?>
                                            <?php echo e(__($courierInfo->receiverBranch->name)); ?>

                                        <?php else: ?>
                                            <?php echo app('translator')->get('N/A'); ?>
                                        <?php endif; ?>
                                    </span>
                                    <br>
                                    <?php if($courierInfo->receiver_staff_id): ?>
                                        <?php echo e(__($courierInfo->receiverStaff->fullname)); ?>

                                    <?php else: ?>
                                        <span><?php echo app('translator')->get('N/A'); ?></span>
                                    <?php endif; ?>
                                </td>

                                <td data-label="<?php echo app('translator')->get('Amount Order Number'); ?>">
                                    <span class="font-weight-bold"><?php echo e(getAmount($courierInfo->paymentInfo->amount)); ?> <?php echo e($general->cur_text); ?></span><br>
                                    <span><?php echo e(__($courierInfo->code)); ?></span>
                                </td>

                                 <td data-label="<?php echo app('translator')->get('Creations Date'); ?>">
                                    <span><?php echo e(showDateTime($courierInfo->created_at, 'd M Y')); ?></span><br>
                                    <span><?php echo e(diffForHumans($courierInfo->created_at)); ?></span>
                                </td>

                                    <td data-label="<?php echo app('translator')->get('Payment Status'); ?>">
                                        <?php if($courierInfo->paymentInfo->status == 1): ?>
                                            <span class="badge badge--success"><?php echo app('translator')->get('Paid'); ?></span>
                                        <?php elseif($courierInfo->paymentInfo->status == 0): ?>
                                            <span class="badge badge--danger"><?php echo app('translator')->get('Unpaid'); ?></span>
                                        <?php endif; ?>
                                    </td>

                                    

                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                        <?php if($courierInfo->status == 0): ?>
                                            <span class="badge badge--primary"><?php echo app('translator')->get('Received'); ?></span>
                                        <?php elseif($courierInfo->status == 1): ?>
                                            <span class="badge badge--success"><?php echo app('translator')->get('Delivery'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                
                                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                        <?php if($courierInfo->status  == 0 && $courierInfo->paymentInfo->status == 1): ?>
                                            <a href="javascript:void(0)" title="" class="icon-btn btn--info ml-1 delivery" data-code="<?php echo e($courierInfo->code); ?>"><?php echo app('translator')->get('Delivery'); ?></a>
                                        <?php endif; ?>
                                        <?php if($courierInfo->status  == 0 && $courierInfo->paymentInfo->status == 0): ?>
                                            <a href="javascript:void(0)" title="" class="icon-btn btn--success ml-1 payment" data-code="<?php echo e($courierInfo->code); ?>"><?php echo app('translator')->get('Payment'); ?></a>
                                        <?php endif; ?>
                                       <a href="<?php echo e(route('staff.courier.invoice', encrypt($courierInfo->id))); ?>" title="" class="icon-btn bg--10 ml-1"><?php echo app('translator')->get('Invoice'); ?></a>
                                       <a href="<?php echo e(route('staff.courier.details', encrypt($courierInfo->id))); ?>" title="" class="icon-btn btn--priamry ml-1"><?php echo app('translator')->get('Details'); ?></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>



<div class="modal fade" id="paymentBy" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="" lass="modal-title" id="exampleModalLabel"><?php echo app('translator')->get('Payment Confirmation'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
            </div>
            
            <form action="<?php echo e(route('staff.courier.payment')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('POST'); ?>
                <input type="hidden" name="code">
                <div class="modal-body">
                    <p><?php echo app('translator')->get('Are you sure to collect this amount?'); ?></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--secondary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <button type="submit" class="btn btn--success"><?php echo app('translator')->get('Yes'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="deliveryBy" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="" lass="modal-title" id="exampleModalLabel"><?php echo app('translator')->get('Delivery Confirmation'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
            </div>
            
            <form action="<?php echo e(route('staff.courier.delivery')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('POST'); ?>
                <input type="hidden" name="code">
                <div class="modal-body">
                    <p><?php echo app('translator')->get('Are you sure to delivery this courier?'); ?></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--secondary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <button type="submit" class="btn btn--success"><?php echo app('translator')->get('Confirm'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('script'); ?>
<script>
    'use strict';
    $('.payment').on('click', function () {
        var modal = $('#paymentBy');
        modal.find('input[name=code]').val($(this).data('code'))
        modal.modal('show');
    });

    $('.delivery').on('click', function () {
        var modal = $('#deliveryBy');
        modal.find('input[name=code]').val($(this).data('code'))
        modal.modal('show');
    });
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('staff.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/highogyr/public_html/core/resources/views/staff/dashboard.blade.php ENDPATH**/ ?>